# -*- coding: utf-8 -*-
"""
Created on Thu Oct 14 14:39:47 2021

@author: s168562

Some useful documentation on the h5py package:
https://www.christopherlovell.co.uk/blog/2016/04/27/h5py-intro.html
https://docs.h5py.org/en/stable/quick.html

Script to collect all file names, sample names and detector distances in a csv 
file per folder.
"""
### preliminaries
import os
import re
import csv
import h5py
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

'''Define a function which print names of group members'''
def printname(name):
    print(name)

### Define input files
f1 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\Graphene_data-20220831-091434-water"
f2 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\Graphene_data-20220831-103133-capillaries"
f3 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\Graphene_data-20220831-174131"
f4 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\Graphene_data-20220901-093426"
f5 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\1_Graphene_data_rheoSAXS_GNP24_dowanol"
f6 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\2_Graphene_data_rheoSAXS_GNP24_dowanol_TPU"
f7 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\3_Graphene_data_rheoSAXS_size_series_dowanol_TPU"
f8 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\4_Graphene_data_rheoSAXS_M5_dowanol_TPU"
f9 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\5_Graphene_data_rheoSAXS_ink"
f10 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\6_Graphene_data_rheoSAXS_oscillatory"
f11 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\7_Graphene_data_rheoSAXS_overnight"
f12 = r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_IHSC1728\8_Graphene_data_rheoSAXS_BG"

# file = r"Graphene_eiger2_16161_ave.h5"
# folderpath = fpath9

# fpaths = [f1, f2, f3, f4]
fpaths = [f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12]


for folderpath in fpaths:
    print(folderpath)
    title_list = []
    file_list = []
    det_list = []
    # data_array = np.array([])
    df = pd.DataFrame(columns = ['Sample', 'q', 'data'])
    counter = 0
    for file in os.listdir(folderpath):
        filepath = os.path.join(folderpath, file)
        counter += 1
        # if filepath.endswith('[0-9]_ave.h5'):
        if (re.search(r"\w+eiger2_[0-9]+_ave.h5$",filepath)): # SAXS files
            with h5py.File(filepath, 'r') as hf:
                hf_title = hf.get('entry_0000/PyFAI/id02-eiger2-saxs/header/Title')
                title_b = hf_title[()]
                title = title_b.decode("utf-8") 
                det_dist_b = hf.get('entry_0000/PyFAI/id02-eiger2-saxs/header/SampleDistance')[()]
                det_dist = det_dist_b.decode("utf-8")
                title_list.append(title)
                file_list.append(file)
                det_list.append(det_dist)
                # print(counter, ':', title)
                
                # hf_q = hf.get('entry_0000/PyFAI/result_ave/q')
                # q = hf_q[()][:]
                # hf_data = hf.get('entry_0000/PyFAI/result_ave/data')
                # data = hf_data[()][0]
                
        elif (re.search(r"\w+waxs_[0-9]+_ave.h5$",filepath)): # WAXS files
            with h5py.File(filepath, 'r') as hf:
                hf_title = hf.get('entry_0000/PyFAI/id02-rayonixhs-waxs/header/Title')
                title_b = hf_title[()]
                title = title_b.decode("utf-8") 
                det_dist_b = hf.get('entry_0000/PyFAI/id02-rayonixhs-waxs/header/SampleDistance')[()]
                det_dist = det_dist_b.decode("utf-8")
                title_list.append(title)
                file_list.append(file)
                det_list.append(det_dist)
       
    # write titles to csv         
    header = ['file_name','sample_name', 'detector_dist']
    file_samples = list(zip(file_list, title_list, det_list))
    csvpath = os.path.join(folderpath, "0_sample_list.csv")
    with open(csvpath, 'w', newline='') as f:
        writer = csv.writer(f)
        writer.writerow(header)
        writer.writerows(file_samples)


# PyFAI/result_ave/q
# PyFAI/result_ave/data
    

# # Access names of group members:
# # test file _scalers_
# hf = h5py.File(r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_SC5184\Graphene\test\Graphene_scalers_05504_raw.h5", 'r');
# # iterate over an entire file
# hf.visit(printname)
# # get a list of many many properties
# for name in hf.get('entry_0000/id02/parameters'):
#     print(name)
# for name in hf.get('entry_0000'):
#     print(name)
# hf.get('entry_0000/id02/name')[()]
# hf.get('entry_0000/title')[()] # 'C216 metadata collection'

# test file _waxs_
hf = h5py.File(r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_SC5184\Graphene\test\Graphene_waxs_07742_ave.h5", 'r');
# iterate over an entire file
hf.visit(printname)
# get a list of many many properties
for name in hf.get('entry_0000/PyFAI'):
    print(name)
for name in hf.get('entry_0000'):
    print(name)
hf.get('entry_0000/PyFAI/id02-rayonixhs-waxs/header/Title')[()]
hf.get('entry_0000/PyFAI/id02-rayonixhs-waxs/header/SampleDistance')[()]
hf.get('entry_0000/PyFAI/parameters/WaveLength')[()]

# # test file _SAXS
# hf = h5py.File(r"\\st-a2401\TOMO8\Hazendonk_Laura_van\ESRF_SC5184\Graphene\test\Graphene_eiger2_08711_ave.h5", 'r');
# # iterate over an entire file
# hf.visit(printname)
# hf.get('entry_0000/PyFAI/id02-eiger2-saxs/header/SampleDistance')[()]
    
# # to practice
# file = r"Graphene_eiger2_16161_ave.h5"
# filepath = os.path.join(folderpath, file)
# hf = h5py.File(filepath, 'r')
# hf_q = hf.get('entry_0000/PyFAI/result_ave/q')
# q = hf_q[()]
# hf_data = hf.get('entry_0000/PyFAI/result_ave/data')
# data = hf_data[()]

# # plot
# plt.figure(figsize= [10*cm, 7*cm])
# plt.plot(q, data, label = r'$R$',
#          color = cbPalVivid[3], linewidth = 2)
# ax = plt.axes()
# ax.set_xscale('log')
# ax.set_yscale('log')
# ax = plt.axes()
# # ax.set_ylim(2, 6)
# # ax.set_yticks([2, 3, 4, 5, 6])
# ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
#                top = "on")
# ax.set_facecolor("white")
# plt.xlabel(r'q [nm]$^{-1}$')
# plt.ylabel(r'Intensity')
# # figurepath_tiff = os.path.join(outpathfull, "test.tiff")
# # figurepath_pdf = os.path.join(outpathfull, "test.pdf")
# # plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
# # plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
# plt.show()


# alles groeperen op titel in een dictionary? samples['testsample']: {graphene_eiger2_1, graphene_eger2_2, etc}
